function [chan,o_out] = punc_align(ori,chan_tmp)
%This function takes one puncta set and translates it to the origin, and
%bring all the other channels along for the ride.
%Synatax:   [c_out,t_out,o_out,flprot_idx] = syn_align(ori,termi,chan);
%Input:     ori = a list of vertices.  Note: if an array have more than
%               3 columns, only the first three will be considered.  Ori
%               will be come 0,0,0
%           chan_tmp = list of vertices.  Either a single list or a cell array.
%           Note: if no input is given, the function will ask to import
%           CSVs.
%Output:    chan = the rotated chan vertices.If cell array will match cell
%               dimensions.
%           o_out = the translated origin vertices list all 0 0 0.


if nargin<3    %no input, open files.
    %ori
    prompt_box('title','Open Vertex Lists','prompt1','Select the Origin vertex lists.','position','center');
    pause(0.25);
    [filename,pathname,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open Origin CSV','Multiselect','off');
    %open ori list
    ori = single(dlmread([pathname,filename{1,1}],',',1,0));
    %chan
    prompt_box('title','Open Vertex Lists','prompt1','Select all other Channel vertex lists.','position','center');
    pause(0.25);
    [filename,pathname,filterindex] = uigetfile2({'*.csv','Text files (*.csv)';'*.*','All Files';},...
        'Open Channel CSVs','Multiselect','on');
    %open chan list
    for i = 1:size(filename,2)
            chan{i} = single(dlmread([pathname,filename{1,i}],',',1,0));
    end
else
    %if chan is input as a single array
    if ~iscell(chan_tmp)
        chan{1} = chan_tmp;     %make a cell array
    else
        chan = chan_tmp;
    end
end
clear chan_tmp

%Translate all the points first
o_tmp =  zeros(size(ori,1),3); %translate ori to 0,0,0.  This is assuming that all vertices are positive, which for an image should be true.
%translate chan
for j = 1:size(chan,2)
    c_tmp{j} = chan{j}(:,1:3)-ori(:,1:3);       %translate channels
end
chan = c_tmp;   %output